﻿import viz
import vizconnect
import vizshape

vizconnect.go ('vizconnect_config.py')

scene = viz.addChild ('piazza.osgb')

crate = viz.addChild('crate.osgb',pos=[0,0.5,3])
crate.setScale([4]*3)

from tools import collision_test

class BoundingBox(collision_test.DistanceTest):
	"""Measures distance based on the center points of two objects"""
	def getClosest(self, start, list, closestItem=None, closestDistance=-1):
		"""Returns the closest node found along with the distance
		@return (viz.VizNode(), float)
		"""
		self._mode = viz.ABS_GLOBAL
		self._highlightRadius = 0.01
		sphere = start.getBoundingSphere(viz.ABS_GLOBAL)
		if sphere.radius < 0:
			startPos = start.getPosition(viz.ABS_GLOBAL)
		else:
			startPos = sphere.center
		for item in list:
			bs = item.getBoundingSphere(self._mode)
			dist = vizmat.Distance(startPos, bs.center)
			if dist < bs.radius+self._highlightRadius and (dist < closestDistance or closestDistance == -1):
				closestItem = item
				closestDistance = dist
			bs = item.getBoundingSphere(self._mode)
		return closestItem, closestDistance
	
	def getAllInRange(self, start, list, threshold):
		"""Returns a list of tuples containing the set of nodes within
		a given range node found along with the distance. If threshold
		is None, then the returned list is not be filtered by distance.
		@return []
		"""
		self._mode = viz.ABS_GLOBAL
		startPos = start.getBoundingSphere(viz.ABS_GLOBAL).center
		result = []
		for item in list:
			bs = item.getBoundingSphere(self._mode)
			print dist, bs.radius+self._highlightRadius
			# get the distance between the hand and the item
			dist = vizmat.Distance(startPos, bs.center)
			if dist < bs.radius+self._highlightRadius:
				result.append((item, dist))
		return result



class BoundingBoxDistance(collision_test.Distance):
	"""Distance-base collision tester. Finds objects withing a certain distance
	of the provided node.
	"""
	def _onGet(self, validList):
		"""An internal method which must be implemented in any subclass. It
		returns either a list of items, if self._all is True, or a single tuple
		if False. This function should apply the distanceTest in order to 
		filter/order the objects as appropriate. This method is called by
		getAllInRange and getClosest.
		"""
		# if we want all the nodes, check for dist vs min threshold
		if self._all:
			return self._distanceTest.getAllInRange(self._node, validList, self._distanceThreshold)
		
		# get the item with the min distance
		item, dist = self._distanceTest.getClosest(self._node, validList)
		return (item, dist)



tool = vizconnect.getRawTool('grabber')
tool.setCollisionTester(BoundingBoxDistance(node=tool, distanceTest=BoundingBox()))
tool.setItems([crate])